public class Rectangle extends Shape {
  private Point[] rp;

  public Rectangle(Point[] p) {
    cp(4, p);
  }

  private void cp(int n, Point[] p) {
    rp = new Point[n];

    for (int i = 0; i < n; i++) {
      rp[i] = p[i];
    }
  }

  public double perimeter() {
    int n = rp.length;
    double sum = 0;

    for (int i = 0; i < n; i++) {
      sum += rp[i].subtract(rp[(i + 1) % n]).d();
    }
    return sum;
  }

  public double area() {
    double h = rp[0].subtract(rp[1]).d();
    double w = rp[1].subtract(rp[2]).d();
    return h * w;
  }

  public String name() {
    return "rectangle";
  }
}
