public class Triangle extends Shape {
  private Point[] tp;

  public Triangle(Point[] p) {
    cp(3,p);
  }

  private void cp(int n, Point[] p) {
    tp = new Point[n];
    for(int i = 0; i < n; i++)
      tp[i] = p[i];
  }

  public double perimeter() {
    int N = tp.length;
    double sum = 0;

    for(int i = 0; i < N; i++){
      sum += tp[i].subtract(tp[(i+1)%N]).d();
    }
    return sum;
  }

  public double area() {
    double s = perimeter()/2;
    double sa = s - tp[0].subtract(tp[1]).d();
    double sb = s - tp[1].subtract(tp[2]).d();
    double sc = s - tp[2].subtract(tp[0]).d();
    return Math.sqrt(s*sa*sb*sc);
  }

  public String name() {
    return "triangle";
  }
}
